<?php

    include "../../conn.php";
    include "../../functions2.php";

    header('Content-Type: application/json; charset=utf-8');
    header('Strict-Transport-Security: max-age=31536000');
    header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
    header('Access-Control-Allow-Credentials: true');
    $origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
    header('Access-Control-Allow-Origin: ' . $origin);
    header('vary: Origin');
    
    date_default_timezone_set("Asia/Kolkata");
    $shnunc = date("Y-m-d H:i:s");
    $res = [
        'code' => 11,
        'msg' => 'Method not allowed',
        'msgCode' => 12,
        'serviceNowTime' => $shnunc,
    ];
    $shonubody = file_get_contents("php://input");
    $shonupost = json_decode($shonubody, true);
    
    if ($_SERVER['REQUEST_METHOD'] != 'GET') {
        if (isset($shonupost['withdrawId']) && isset($shonupost['mobileNo']) && isset($shonupost['bankId']) && isset($shonupost['beneficiaryName']) && isset($shonupost['codeType']) && isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['timestamp'])) {
            
            $withdrawId = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['withdrawId']));
            $mobileNo = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['mobileNo']));
            $bankId = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['bankId']));
            $smsCode = isset($shonupost['smsCode']) ? htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['smsCode'])) : '';
            $beneficiaryName = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['beneficiaryName']));
            $type = isset($shonupost['type']) ? htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['type'])) : '';
            $codeType = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['codeType']));
            $language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
            $random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
            $signature = isset($shonupost['signature']) ? htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature'])) : '';
            $timestamp = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['timestamp']));
            
            // Signature validation removed - proceed directly to authentication
            $bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
            $author = $bearer[1];				
            $is_jwt_valid = is_jwt_valid($author);
            $data_auth = json_decode($is_jwt_valid, 1);
            
            if($data_auth['status'] === 'Success') {
                $sesquery = "SELECT id, akshinak
                  FROM shonu_subjects
                  WHERE akshinak = '$author'";
                $sesresult=$conn->query($sesquery);
                $sesnum = mysqli_num_rows($sesresult);
                
                if($sesnum == 1){
                    // Get user ID from database
                    $sesrow = mysqli_fetch_assoc($sesresult);
                    $userId = $sesrow['id'];
                    
                    // Check if user already has a withdrawal request
                    $checkQuery = "SELECT id FROM withdrawal_requests WHERE withdraw_id = '$userId'";
                    $checkResult = $conn->query($checkQuery);
                    $existingRecords = mysqli_num_rows($checkResult);
                    
                    if($existingRecords > 0) {
                        $res['code'] = 13;
                        $res['msg'] = 'Cannot save multiple records. Only 1 withdrawal request accepted per user.';
                        $res['msgCode'] = 13;
                        $res['serviceNowTime'] = $shnunc;
                        http_response_code(200);
                        echo json_encode($res);
                    } else {
                        // Insert withdrawal request into database with user ID instead of withdraw ID
                        $insertQuery = "INSERT INTO withdrawal_requests (withdraw_id, mobile_no, bank_id, sms_code, beneficiary_name, type, code_type, language, random_string, signature, timestamp, created_at, user_token) 
                        VALUES ('$userId', '$mobileNo', '$bankId', '$smsCode', '$beneficiaryName', '$type', '$codeType', '$language', '$random', '$signature', '$timestamp', '$shnunc', '$author')";
                        
                        if($conn->query($insertQuery)) {
                            $res['code'] = 0;
                            $res['msg'] = 'Succeed';
                            $res['msgCode'] = 0;
                            $res['serviceNowTime'] = $shnunc;
                            http_response_code(200);
                            echo json_encode($res);
                        } else {
                            $res['code'] = 10;
                            $res['msg'] = 'Database error';
                            $res['msgCode'] = 10;
                            $res['serviceNowTime'] = $shnunc;
                            http_response_code(200);
                            echo json_encode($res);
                        }
                    }
                } else {
                    $res['code'] = 8;
                    $res['msg'] = 'Unauthorized user';
                    $res['msgCode'] = 8;
                    $res['serviceNowTime'] = $shnunc;
                    http_response_code(200);
                    echo json_encode($res);
                }
            } else {
                $res['code'] = 9;
                $res['msg'] = 'Invalid token';
                $res['msgCode'] = 9;
                $res['serviceNowTime'] = $shnunc;
                http_response_code(200);
                echo json_encode($res);
            }
        } else {
            $res['code'] = 7;
            $res['msg'] = 'Param is Invalid';
            $res['msgCode'] = 6;
            $res['serviceNowTime'] = $shnunc;
            http_response_code(200);
            echo json_encode($res);
        }		
    } else {		
        http_response_code(405);
        echo json_encode($res);
    }	
?>